package com.ejie.aa17a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa17a.model.Aa17aAviso;
import com.ejie.aa17a.model.Aa17aBanda;
import com.ejie.aa17a.model.Aa17aContaminante;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.model.Aa17aEstacion;
import com.ejie.aa17a.service.iface.Aa17aAvisoService;
import com.ejie.aa17a.service.iface.Aa17aBandaService;
import com.ejie.aa17a.service.iface.Aa17aContaminanteService;
import com.ejie.aa17a.service.iface.Aa17aDatoHistoricoService;
import com.ejie.aa17a.service.iface.Aa17aDatoHorarioService;
import com.ejie.aa17a.service.iface.Aa17aEstacionService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * Aa17aRegistroMaestroController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/estaciones")
public class Aa17aEstacionesController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aEstacionesController.class);

	private Aa17aEstacionService aa17aEstacionService;
	private Aa17aAvisoService aa17aAvisoService;
	private Aa17aDatoHorarioService aa17aDatoHorarioService;
	private Aa17aBandaService aa17aBandaService;
	private Aa17aContaminanteService aa17aContaminanteService;
	private Aa17aDatoHistoricoService aa17aDatoHistoricoService;
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "busqueda", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		Aa17aEstacionesController.logger.info("[GET - View] : estacionesBusqueda");

		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO); //busco solo las estaciones activas
		List<Aa17aEstacion> estaciones = this.aa17aEstacionService.findAll(filterAa17aEstacion);

		model.addAttribute("listEstaciones", estaciones);

		return new ModelAndView("estacionesBusqueda", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param idEstacion
	 *            Long
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "detalle/{idEstacion}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable Long idEstacion, Model model) {
		Aa17aEstacionesController.logger.info("[GET - View] : estacionesDetalle");

		model.addAttribute("idEstacion", idEstacion);

		//Obtengo los datos de la estacion
		Aa17aEstacion filterAa17aEstacion = new Aa17aEstacion();
		filterAa17aEstacion.setIdEstacion(idEstacion);
		Aa17aEstacion estacion = this.aa17aEstacionService.getEstacionConBanda(filterAa17aEstacion);
		model.addAttribute("estacion", estacion);

		//obtengo la lista de avisos de la estacion
		Aa17aAviso filterAa17aAviso = new Aa17aAviso();
		filterAa17aAviso.setEstado(Aa17aConstantes.ESTADO_ACTIVO);//busco solo los que estén activos
		filterAa17aAviso.setIdEstacion(idEstacion);
		List<Aa17aAviso> listAvisos = this.aa17aAvisoService.findAll(filterAa17aAviso);
		model.addAttribute("listAvisos", listAvisos);

		Aa17aDatoHorario datoHorarioFiltro = new Aa17aDatoHorario();
		datoHorarioFiltro.setIdEstacion(idEstacion);

		//obtengo la ultima fecha de la que se tenga información de datos horarios de algún contaminante
		Date fechaUltimaMedicion = this.aa17aDatoHorarioService.getUltimaFechaMedida(datoHorarioFiltro);
		Date ultimaMedidaHoraria = null;
		List<Aa17aDatoHorario> listDatosHorarios = new ArrayList<Aa17aDatoHorario>();

		//si tengo fecha de ultima medicion
		if (fechaUltimaMedicion != null) {
			//obtengo los datos horarios de esta fecha para la estacion
			datoHorarioFiltro.setFechaDato(fechaUltimaMedicion);
			listDatosHorarios = this.aa17aDatoHorarioService.findAll(datoHorarioFiltro);

			//si tengo datos, obtengo la fecha + hora de la ultima medicion
			if (listDatosHorarios != null && listDatosHorarios.size() > 0) {
				ultimaMedidaHoraria = listDatosHorarios.get(0).getUltimaMedidaHoraria();

				Aa17aDatoHistorico datoHistoricoFiltro = new Aa17aDatoHistorico();
				datoHistoricoFiltro.setIdEstacion(idEstacion);

				Aa17aBanda bandaFiltro = new Aa17aBanda();

				for (Aa17aDatoHorario datoHorario : listDatosHorarios) {

					/*
					 * si se trata de un parametro de tipo Contaminante y además tiene configurado un tipo de cálculo de ICA,
					 * obtengo los datos de la banda correspondiente
					 */
					if (datoHorario.getContaminante().getTipoParametro().equals(Aa17aConstantes.TIPO_PARAMETRO_CONTAMINANTE) &&
							datoHorario.getContaminante().getTipoCalculoICA() != null && datoHorario.getContaminante().getTipoCalculoICA() != Aa17aConstantes.MAGIC_NUMBER_0) {
						datoHistoricoFiltro.setContaminante(datoHorario.getContaminante());

						Long idBanda = this.aa17aDatoHistoricoService.getIdBandaContaminante(datoHistoricoFiltro);
						if (idBanda == null) {
							idBanda = Aa17aConstantes.ID_BANDA_SIN_DATOS; //si no tienen datos, muestro el icono azul de no hay datos
						}

						bandaFiltro.setIdBanda(idBanda);
						datoHorario.setBanda(this.aa17aBandaService.find(bandaFiltro));
					}
				}
			}

		}
		model.addAttribute("listDatosHorarios", listDatosHorarios);
		//fecha y hora de la ultima medicion
		model.addAttribute("ultimaMedidaHoraria", Aa17aFuncionesComunes.formatearFechaHora24(ultimaMedidaHoraria, LocaleContextHolder.getLocale()));

		return new ModelAndView("estacionesDetalle", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "ayuda", method = RequestMethod.GET)
	public ModelAndView getCreateFormAyuda(Model model) {
		Aa17aEstacionesController.logger.info("[GET - View] : estacionesAyuda");

		//obtengo la lista de bandas
		Aa17aBanda filtroBanda = new Aa17aBanda();
		filtroBanda.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		//List<Aa17aBanda> listBandas = this.aa17aBandaService.findAll(filtroBanda);
		model.addAttribute("listBandas", this.aa17aBandaService.findAll(filtroBanda));

		Aa17aContaminante filtroContaminante = new Aa17aContaminante();
		filtroContaminante.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		//List<Aa17aContaminante> listContaminantes = this.aa17aContaminanteService.findAll(filtroContaminante);
		model.addAttribute("listContaminantes", this.aa17aContaminanteService.findAll(filtroContaminante));

		return new ModelAndView("estacionesAyuda", "model", model);
	}

	/**
	 * Method 'getCreateFormMapa'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "mapa", method = RequestMethod.GET)
	public ModelAndView getCreateFormMapa(Model model) {
		Aa17aEstacionesController.logger.info("[GET - View] : mapa");
		model.addAttribute("keyGoogleMaps", this.appConfiguration.get(Aa17aConstantes.CONFIG_KEY_GOOGLE_MAPS));

		return new ModelAndView("mapa", "model", model);
	}

	/**
	 * Method 'getCreateFormAyudaMapa'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "ayudaMapa", method = RequestMethod.GET)
	public ModelAndView getCreateFormAyudaMapa(Model model) {
		Aa17aEstacionesController.logger.info("[GET - View] : mapaAyuda");

		//obtengo la lista de bandas
		Aa17aBanda filtroBanda = new Aa17aBanda();
		filtroBanda.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
		model.addAttribute("listBandas", this.aa17aBandaService.findAll(filtroBanda));

		return new ModelAndView("mapaAyuda", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aEstacion
	 *            Aa17aEstacion
	 * @return List
	 */
	@RequestMapping(value = "lista", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aEstacion> getAll(@ModelAttribute Aa17aEstacion filterAa17aEstacion) {
		Aa17aEstacionesController.logger.info("[GET - find_ALL] : Obtener Aa17aEstacion por filtro");
		filterAa17aEstacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO); //busco solo las estaciones activas
		//return this.aa17aEstacionService.findAll(filterAa17aEstacion);
		return this.aa17aEstacionService.getListEstacionesConBanda(filterAa17aEstacion);
	}

	/**
	 * @param aa17aEstacionService
	 *            the aa17aEstacionService to set
	 */
	public void setAa17aEstacionService(Aa17aEstacionService aa17aEstacionService) {
		this.aa17aEstacionService = aa17aEstacionService;
	}

	/**
	 * @param aa17aAvisoService
	 *            the aa17aAvisoService to set
	 */
	public void setAa17aAvisoService(Aa17aAvisoService aa17aAvisoService) {
		this.aa17aAvisoService = aa17aAvisoService;
	}

	/**
	 * @param aa17aDatoHorarioService
	 *            the aa17aDatoHorarioService to set
	 */
	public void setAa17aDatoHorarioService(Aa17aDatoHorarioService aa17aDatoHorarioService) {
		this.aa17aDatoHorarioService = aa17aDatoHorarioService;
	}

	/**
	 * @param aa17aBandaService
	 *            the aa17aBandaService to set
	 */
	public void setAa17aBandaService(Aa17aBandaService aa17aBandaService) {
		this.aa17aBandaService = aa17aBandaService;
	}

	/**
	 * @param aa17aContaminanteService
	 *            the aa17aContaminanteService to set
	 */
	public void setAa17aContaminanteService(Aa17aContaminanteService aa17aContaminanteService) {
		this.aa17aContaminanteService = aa17aContaminanteService;
	}

	/**
	 * @param aa17aDatoHistoricoService
	 *            the aa17aDatoHistoricoService to set
	 */
	public void setAa17aDatoHistoricoService(Aa17aDatoHistoricoService aa17aDatoHistoricoService) {
		this.aa17aDatoHistoricoService = aa17aDatoHistoricoService;
	}

	/**
	 * @param appConfiguration
	 *            the appConfiguration to set
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
